<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7; IE=EmulateIE9" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<link rel="icon" href="styles/img/favicon.ico" type="image/x-icon" />
	<title>{$settings.site_name} | Simplified Managed Crypto Trading</title>
	<script>
		document.write("<link rel='stylesheet' href='styles/css/main.css?v=" + Date.now() + "'>")
	</script>
	<link rel="stylesheet" href="styles/css/owl.carousel.min.css" />
	<link rel="stylesheet" href="styles/css/owl.theme.default.min.css" />
	<link rel="stylesheet" href="styles/css/swiper.min.css">
	<!--[if lt IE 9]>
            <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
            <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
        <![endif]-->
</head>

<body class="body-bg">
	<a target="_blank" href="https://t.me" class="telegram-group">
		<svg xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="-21 -51 682.66669 682" width="512px">
			<path d="m640-1.667969-640 272.039063 167.777344 66.585937 59.726562 224.507813 109.976563-106.558594 178.917969 123.570312zm-403.78125 367.402344-6.457031 58.535156-24.800781-93.234375 435.039062-332.703125zm0 0" fill="#fff" />
		</svg> <span>Telegram Group</span>
	</a>
	<!-- header -->
	<header id="bw-header">
		<section id="bw-header-up">
			<div class="container">
				<div class="">
					<a href="?a=home" class="logo">
						<img src="styles/img/logo/logo.svg" />
					</a>
					<nav class="float-left">
						<ul class="main-menu">
							<li><a href="?a=home">Home</a>
							</li>
							<li><a href="?a=about">About Us</a>
							</li>
							<li><a href="?a=cust&amp;page=investment">Managed Investment</a>
							</li>
							<li><a href="?a=cust&amp;page=partnership">Referral Program</a>
							</li>
							<li><a class="active" href="?a=support">Help Center</a>
							</li>
							<li><a href="?a=news">News</a>
							</li>
						</ul>
					</nav>
					<div>
						<div class="float-right d-block d-md-none">
							<button onclick="CoHeaderMenu('#bw-header-menu')" class="toggle-menu">
								<svg height="20" width="20">
									<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" id="menu" width="100%" height="100%">
										<path d="M491.318 235.318H20.682C9.26 235.318 0 244.577 0 256s9.26 20.682 20.682 20.682h470.636c11.423 0 20.682-9.259 20.682-20.682 0-11.422-9.259-20.682-20.682-20.682zm0-156.879H20.682C9.26 78.439 0 87.699 0 99.121c0 11.422 9.26 20.682 20.682 20.682h470.636c11.423 0 20.682-9.26 20.682-20.682 0-11.422-9.259-20.682-20.682-20.682zm0 313.758H20.682C9.26 392.197 0 401.456 0 412.879s9.26 20.682 20.682 20.682h470.636c11.423 0 20.682-9.259 20.682-20.682s-9.259-20.682-20.682-20.682z"></path>
									</svg>
								</svg>
							</button>
						</div> <a href="?a=paidout" class="payment-proof float-right d-none d-md-block">Payment Proofs</a>
						<div class="clearfix"></div>
					</div>
				</div>
			</div>
		</section>
		<section id="bw-header-menu">
			<div onclick="CoHeaderMenu('#bw-header-menu')" class="close-menu float-right d-block d-md-none"></div>
			<div class="container">
				<div id="bw-menu" class="menu">
					<nav class="float-left">
						<ul class="main-menu">
							<li><a href="?a=home">Home</a>
							</li>
							<li><a href="?a=about">About Us</a>
							</li>
							<li><a href="?a=cust&amp;page=investment">Managed Investment</a>
							</li>
							<li><a href="?a=cust&amp;page=partnership">Referral Program</a>
							</li>
							<li><a class="active" href="?a=support">Help Center</a>
							</li>
							<li><a href="?a=news">News</a>
							</li>
							<li><a href="?a=paidout">Payment Proofs</a>
							</li>
						</ul>
					</nav>
					<ul class="auth float-right btn btn-bw">
						{if $userinfo.logged != 1}	
						<li> <a href="?a=login" class="">Login</a>
						</li>
						<li> <a href="?a=signup" class="">Register</a>
						</li>
						{else}
						<li> <a href="?a=account" class="">Dashboard</a>
						</li>
						<li> <a href="?a=logout" class="">Logout</a>
						</li>
						{/if}
					</ul>
				</div>
			</div>
		</section>
	</header>
	<!-- end header -->
</body>

</html>
<script src="https://code.jquery.com/jquery-1.9.1.min.js" integrity="sha256-wS9gmOZBqsqWxgIVgA8Y9WcQOa7PgSIX+rPA0VL2rbQ=" crossorigin="anonymous">
</script>
<!-- main -->
<main id="bw-wrapper">
	<!-- bw-page-header -->
	<section id="bw-page-header" class="bg-header-faq">
		<div class="container">
			<div class=" bw-section-title-vertical-reverse ">
				<h2 class="title">Help Center </h2>
				<div class="desc">Find answers to your questions</div>
			</div>
			<div class="input-box">
				<svg class="icon">
					<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 21.09 24.08" id="search" width="100%" height="100%">
						<g clip-path="url(#a)">
							<path d="M9.39 18.78a9.39 9.39 0 1 1 9.39-9.39 9.4 9.4 0 0 1-9.39 9.39zm0-17A7.59 7.59 0 1 0 17 9.39 7.6 7.6 0 0 0 9.39 1.8z"></path>
							<path d="M18.35 24.08a2.78 2.78 0 0 1-.46 0 2.72 2.72 0 0 1-1.78-1.11l-3.76-5.26a.9.9 0 0 1 1.46-1l3.76 5.26a.93.93 0 0 0 .61.38.94.94 0 0 0 .7-.16.94.94 0 0 0 .22-1.31l-3.75-5.26a.9.9 0 0 1 1.46-1l3.75 5.26a2.74 2.74 0 0 1-2.22 4.33z"></path>
						</g>
					</svg>
				</svg>
				<input id="helpSearch" data-toggle="hideseek" data-list=".questions" placeholder="Search Questions" class="form-control">
			</div>
		</div>
	</section>
	<!-- end bw-page-header -->
	<!-- bw-partnership-box -->
	<section id="bw-faq-box" class="mb-5">
		<div class="ask-box">
			<button data-modal="true" data-target="#ask-modal" class="ask-now" type="button"><span>&plus;</span> &nbsp; Send us a Message</button>
		</div>
		<div class="container">
			<div class="cf-tab">
				<div class="cf-tab-links">
					<ul>
						<li class="active" data-target="#General-Questions" data-role="cf-tab">General <span> Questions</span>
						</li>
						<li data-target="#Dashboard-Questions" data-role="cf-tab">Dashboard<span> Questions</span>
						</li>
						<li data-target="#Investment-Questions" data-role="cf-tab">Investment<span> Questions</span>
						</li>
						<li data-target="#Withdraw-Questions" data-role="cf-tab">Withdraw<span> Questions</span>
						</li>
						<li data-target="#Referral-Questions" data-role="cf-tab">Referral<span>Questions</span>
						</li>
					</ul>
				</div>
				<div class="cf-tab-content mt-4">
					<div id="General-Questions" class="cf-tab-content-box active animated fadeIn">
						<ul class="questions">
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">What is {$settings.site_name}?</h2>
								<div class="clearfix"></div>
								<div class="answer">{$settings.site_name} will get you started on one thing: Acquire cryptocurrencies in minutes through a simple and intuitive platform in order to generate revenue from the world of cryptocurrencies.
									<br>{$settings.site_name} GROUP LTD. is an independently owned cryptocurrency trading company placed in the United Kingdom, London. The team consists of expert traders and market analysts who use their skills to manage your capital through cryptocurrency markets.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">Why should I trust {$settings.site_name}?</h2>
								<div class="clearfix"></div>
								<div class="answer">{$settings.site_name} GROUP LTD. is developed, hosted and regulated in United Kingdom with the company registration number of 11122233344. <a href="https://beta.companieshouse.gov.uk" target="_blank">Click here to verify our certificate on UK Companies House</a>.
									<br>We apply the highest security standards for the protection of your data and funds, which will remain totally encrypted and confidential.
									<br>We maintain bank level security, which is continually and independently tested and audited, and reinforced by ongoing training of all of our staff.
									<br>Our security includes preventative measures, such as 2-step login, and our verification procedures. These are specifically designed to ensure that we are protecting your account from unauthorized access.
									<br>The security of your account is our highest priority.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">Why should I use {$settings.site_name} to earn profits?</h2>
								<div class="clearfix"></div>
								<div class="answer">Cryptocurrency exchanges are built for traders. They fail to provide a solution to beginners who are willing to get started with cryptocurrency industry.
									<br>With {$settings.site_name}, you can utilize the power of cryptocurrency trading in a simple and secure way, no matter where you are, in just a few clicks.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">Who can participate in your program?</h2>
								<div class="clearfix"></div>
								<div class="answer">We accept members from all over the world, irrespective of their citizenship. Our services are available to any individual or legal entity in the world.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">If I need help, how can I talk to someone?</h2>
								<div class="clearfix"></div>
								<div class="answer">If you are facing an issue with any of our services and you do not find the solution in our FAQ section, please reach out to get in touch with our Customer Support Team.
									<br>Here are the different options available to you:
									<br>- Email us at <a href="mailto:support@{$settings.site_name}.com"><span id="id-email-site3">support@{$settings.site_name}.com</span></a>
									<br>- Send us a message via <a href="?a=support" target="_blank">Help Center</a>
									<br>- Call us on <strong>+11 22 333 4444</strong>
									<br>We will be happy to answer your questions from Monday to Sunday!</div>
							</li>
						</ul>
					</div>
					<div id="Dashboard-Questions" class="cf-tab-content-box animated fadeIn">
						<ul class="questions">
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">How can I create an account?</h2>
								<div class="clearfix"></div>
								<div class="answer">Opening an account with us is very easy and it will take less than a minute. You simply need to fill out the signup form located on the <a href="?a=signup">Registration Page</a>.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">Can I have more than one account? </h2>
								<div class="clearfix"></div>
								<div class="answer">Each account must contain an individual email address and genuine personal data. We do not have restrictions on using the same IP address for more than one account. As long as you are able to meet the requirements (email address and genuine personal data), you can have as many accounts as you want.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">I have lost my password, how can I recover it?</h2>
								<div class="clearfix"></div>
								<div class="answer">Please use the <a href="?a=forgot_password" target="_blank">Recover Password</a> form and, your email address and follow the instructions to receive a new password.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">How can I change my password?</h2>
								<div class="clearfix"></div>
								<div class="answer">It is easy. Go to your Dashboard then:
									<br>1. Click on “Settings” at main dashboard menu
									<br>2. Go to the "Change Password" section
									<br>Type in your new password in the specified inputs. This password must be at least 8 characters long, contain special characters and avoid common words.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">How can I set my cryptocurrency addresses?</h2>
								<div class="clearfix"></div>
								<div class="answer">Settings section in your dashboard will enable you to set / change your cryptocurrency addresses or PerfectMoney and Payeer accounts, which will be used in order to withdraw your funds.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">What is the Two-Factor Authentication (2FA)?</h2>
								<div class="clearfix"></div>
								<div class="answer">Two-factor Authentication (2FA) provides much stronger security compared to using only a username and a password.
									<br>Please download the Google Authenticator app, Google Play, or App Store.
									<br>2. Go to the "Change Password" section
									<br>2FA uses your mobile phone to verify your account with an OTP (One-Time Password).
									<br>2FA is strongly recommended at all times for your account security.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">How to activate Two-Factor Authentication?</h2>
								<div class="clearfix"></div>
								<div class="answer">First, you will need to download the Google Authenticator app. Then please follow these steps:
									<br>- Flash the QR code shown on the "Security" section of your {$settings.site_name} account
									<br>- You will get the 2FA code directly on your app
									<br>- Enter the 2FA code on the specified input.
									<br>Then the click on "Enable 2FA" button to activate the 2FA in your account.</div>
							</li>
						</ul>
					</div>
					<div id="Investment-Questions" class="cf-tab-content-box animated fadeIn">
						<ul class="questions">
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">How much can I earn by investing in this platform?</h2>
								<div class="clearfix"></div>
								<div class="answer">We offer an investment package including three invest plans:
									<br> <strong>Plan 1: </strong>0.15% lifetime return per hour. Minimum allowed investment is $10 and maximum is $999.99
									<br> <strong>Plan 2: </strong>0.17% lifetime return per hour. Minimum allowed investment is $1,000 and maximum is $4999.99
									<br> <strong>Plan 3: </strong>0.20% lifetime return per hour. Minimum allowed investment is $5,000 and there is no maximum limit.
									<br>All interest rates are fixed and they will not fluctuate by time.
									<br>Here is an example:
									<br>If you invest $1,000, your investment will activate in the second plan. Therefore, your account will be credited by an hourly interest rate of $1.7 (0.17%) and so $40.8 daily.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">How do I invest funds crypto using my account?</h2>
								<div class="clearfix"></div>
								<div class="answer">Once you have created your account with {$settings.site_name}, you are able to make investment 24/7.
									<br>1- Go to the “Make Investment” page.
									<br>2- Pick up the payment method you would like to invest through.
									<br>3- Choose your desired investment plan.
									<br>4- Enter the amount you would like to invest and click the “Make Investment” button.
									<br>5- You will be provided with an address to have your funds paid to.
									<br>Your investment will activated after you send funds from your wallet to the specified address.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">Which payment options do you accept? </h2>
								<div class="clearfix"></div>
								<div class="answer">Our mission is to add the most possible payment methods and local currencies, so that investing is accessible for everyone with no effort.
									<br>At the current time, you can invest using popular Cryptocurrencies including Bitcoin, Ethereum, BitcoinCash. Litecoin, Dash, DogeCoin. In addition, to simplify the investment process, we accept funds directly in USD through PerfectMoney or Payeer.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">What are my investment limits?</h2>
								<div class="clearfix"></div>
								<div class="answer">You can start investing from 10 USD. The minimum allowed amount to invest is $10 and there is no maximum limitation.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">How long does it take my invested funds to activate on my dashboard?</h2>
								<div class="clearfix"></div>
								<div class="answer">Investments through cryptocurrencies like Bitcoin, will be activated on your account after 3 blockchain network confirmations. Perfectmoney and Payeer investments are activated immediately.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">How can I terminate my investment and get my principal money back?</h2>
								<div class="clearfix"></div>
								<div class="answer">If you want to close your investment and release your funds, please follow these steps:
									<br>- Go to the “Fund Management” section of your dashboard.
									<br>- Search for the investment criteria that you want to be releases and click on “Release Investment” button.
									<br>- In the shown input, enter the amount you want to release from your investment. It can be the whole investment amount or a part of it.
									<br>- Click on “Release” button and confirm the information.
									<br>- Now, the released funds have been added to your account balance.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">Can I release my money at any time?</h2>
								<div class="clearfix"></div>
								<div class="answer">After 48 hours of the investment time, you will be able to be release your total invested money or a part of it.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">Can I release only a part of my invested funds?</h2>
								<div class="clearfix"></div>
								<div class="answer">Yes, you are able to release a part of your total invested money or the whole funds. Please note that if you release the whole funds of an investment, your investment will be terminated.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">Do you charge any fees when I want to release my invested funds?</h2>
								<div class="clearfix"></div>
								<div class="answer">Yes, we charge 5% of the total amount that you request to be released.</div>
							</li>
						</ul>
					</div>
					<div id="Withdraw-Questions" class="cf-tab-content-box animated fadeIn">
						<ul class="questions">
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">After I request a withdrawal, when will I receive funds in my wallet?</h2>
								<div class="clearfix"></div>
								<div class="answer">All PerfectMoney, Payeer, BTC, LTC, Dogecoin withdrawals up to $500 are processed instantly. Larger ones and all withdrawals for ETH, BCH and Dash are processed manually within 24 business hours.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">Are there any amount limitations on withdrawal? </h2>
								<div class="clearfix"></div>
								<div class="answer">The minimum withdrawal amount is $1.00 and there is no maximum limit. You can request as many withdrawals per day as you wish.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">Do you reduce any fees for withdrawal requests? </h2>
								<div class="clearfix"></div>
								<div class="answer">No, we do not reduce any fees on your withdrawal requests. Even All network transaction fees will be paid by {$settings.site_name} and investors do not need to pay for it.</div>
							</li>
						</ul>
					</div>
					<div id="Referral-Questions" class="cf-tab-content-box animated fadeIn">
						<ul class="questions">
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">How does the {$settings.site_name} referral program work?</h2>
								<div class="clearfix"></div>
								<div class="answer">As a partner, if you refer investors to invest with {$settings.site_name}, you will be rewarded by a commission for each investment they make. Each of your referred investors have the potential to generate lifetime commissions.
									<br>All {$settings.site_name} users who joined through your personal referral link will become your referrals and they will be counted as active referrals, if they make investment.
									<br> <strong>Commission example:</strong> 
									<br>You invite one investor, who invests 1000 USD of Bitcoins on his {$settings.site_name} account. As a personal partner, you will earn 5% of this amount, which will be 50 USD worth of Bitcoin and it will be credited directly to the Bitcoin balance of your dashboard.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">How do I get started with {$settings.site_name} referral Program?</h2>
								<div class="clearfix"></div>
								<div class="answer">You can simply participate in {$settings.site_name} referral program by <a href="?a=signup" target="_blank">creating your account</a>.
									<br>You will be provided with a personal referral code link that can be utilized for endorsing our investment services while tracking referrals and commissions. The referral code link can be accessed from the “Referrals” section in your dashboard.
									<br>You are able to share your personal referral link or banners through your website or social media.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">How can I receive my personal referral link?</h2>
								<div class="clearfix"></div>
								<div class="answer">You can easily find your personal referral link on the “My Referrals” section of your account.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">Should I have active investment to receive commissions?</h2>
								<div class="clearfix"></div>
								<div class="answer">No, you are not obligated to make a deposit in order to participate in the referral program and earning commissions.</div>
							</li>
							<li class="question">
								<div class="button">+</div>
								<div class="qs"></div>
								<h2 class="title">What is the regional representative program and what are the benefits to become a regional representative?</h2>
								<div class="clearfix"></div>
								<div class="answer">As a representative, you will earn 10% fixed commission per investments made by your referred clients. You can apply to become a {$settings.site_name}'s regional representative in your area by sending us your marketing plan - how do you plan to promote our platform. For more information and applying as a {$settings.site_name} representative, please send us an email to <a href="mailto:support@templaterex.com">support@templaterex.com</a>.
									<!-- <a href="?a=support">Contact us</a>-->
								</div>
							</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- end bw-partnership-box -->
	<br>
	<br>
	<!-- bw-footer-help -->
	<section id="bw-footer-help" class="mt-5">
		<div class="container ">
			<div id="company-certification" class="news-footer">
				<div class="row bw-flex-center">
					<div class="col-md-8">
						<div class="body">
							<h3>Follow us on social media</h3>
							<p>Be updated by following us on social networks.</p>
						</div>
					</div>
					<div class="col-md-4">
						<ul class="socials">
							<li>
								<a target="_black" href="https://twitter.com">
									<img src="styles/img/socials/twitter.svg">
								</a>
							</li>
							<li>
								<a target="_black" href="https://www.facebook.com">
									<img src="styles/img/socials/facebook.svg">
								</a>
							</li>
						</ul>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-xl-8 col-lg-8 col-md-7">
					<h3 class="title">Need to get in touch? </h3>
					<p class="description">We are here to answer all questions you may have about {$settings.site_name} platform. Get in touch and let us know how we can help.</p>
				</div>
				<div class="col-xl-4 col-lg-4 col-md-5 mt-3">
					<div class="float-right"> <a class="btn btn-white ask-now" data-modal="true" data-target="#ask-modal">Contact Support</a>
					</div>
					<div class="clearfix"></div>
				</div>
			</div>
		</div>
	</section>
	<!-- end bw-footer-help -->
</main>
<!-- end main -->
<!-- ask modal -->
<div id="ask-modal" class="cf-mask cf-auth-mask animated fadeIn">
	<div class="cf-mask-wrapper">
		<div class="all">
			<div class="main">
				<div class="close-mask"></div>
				<div class="body ">
					<div class="container">
						<script>
							function checkForm() {
							                                        var $btn = $('.submit-button');
							                                        $btn.html($btn.data('loading-text'));
							                                    }
						</script>
						<form method="post" name="mainform" onsubmit="return checkForm()"><input type="hidden" name="form_id" value="15538451858815"><input type="hidden" name="form_token" value="7b9fc41be772c32a6f9d2ac1fc428f08">
                                <input type="hidden" name="a" value="support">
                                <input type="hidden" name="action" value="send">

                                

                                                                <div class="form-group">
                                    <div class="input-box2">
                                        <div class="label">
                                            <svg>
                                               <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 10.25 14.68" id="user" width="100%" height="100%">
        
        <g clip-path="url(#a)">
            <path d="M7.94 3A3 3 0 1 1 5 0a3 3 0 0 1 3 3M1.89 8.94L.33 11.42a2.13 2.13 0 0 0 1.8 3.27h6a2.13 2.13 0 0 0 1.8-3.27L8.36 8.94a3.82 3.82 0 0 0-6.46 0"></path>
        </g>
    </svg>
                                            </svg>
                                            <span>Name</span>
                                            </div>

                                        <input value="" data-role="input-box2" name="name" placeholder="Enter Your Name" type="text" class="form-control">
                                    </div>
                                </div>
                                
                                                                <div class="form-group">
                                    <div class="input-box2">
                                        <div class="label">
                                            <svg>
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 13.52 8.2" id="mail" width="100%" height="100%">
        <path d="M12.3 0H1.22A1.22 1.22 0 0 0 0 1.22V7a1.22 1.22 0 0 0 1.22 1.2H12.3A1.22 1.22 0 0 0 13.52 7V1.22A1.22 1.22 0 0 0 12.3 0zm-.17 2l-4.5 2.46a2 2 0 0 1-2 0C1.35 2.08 1.26 2 1.22 2a.44.44 0 0 1-.09-.56.31.31 0 0 1 .46-.12c.15.1 1.79 1 4.38 2.42a1.41 1.41 0 0 0 1.38 0l4.5-2.45a.32.32 0 0 1 .45.19.43.43 0 0 1-.17.52z"></path>
    </svg>
                                            </svg>
                                            <span>Your Email</span>
                                        </div>
                                        <input value="" data-role="input-box2" name="email" placeholder="Enter Your Email" type="email" class="form-control">
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="input-box">
                                         <textarea name="message" rows="6" placeholder="Write your message here ..." type="text" class="form-control"></textarea>
                                    </div>
                                </div>

                                
                                <div class="form-group">
                                    <button value="Send" class="btn btn-second btn-lg btn-block submit-button">Send Message</button>
                                </div>
                            </form>
					</div>
				</div>
				<div class="footer">
					<div class="container">
						<div class="row bw-flex-center">
							<div class="col-xl-6 col-lg-6 col-md-6">
								<div class="title">
									<svg>
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 6.14 9.2" id="location" width="100%" height="100%">
											<g clip-path="url(#a)">
												<path d="M3.08 0A3.07 3.07 0 0 0 .41 4.6l2.65 4.6 2.66-4.6A3.07 3.07 0 0 0 3.08 0m0 4.92a1.76 1.76 0 1 1 1.75-1.76 1.76 1.76 0 0 1-1.76 1.76"></path>
											</g>
										</svg>
									</svg> Our Address</div>
								<p>New York 1735 Bingamon Branch Road</p>
							</div>
							<div class="col-xl-3 col-lg-3 col-md-3">
								<div class="title">
									<svg>
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 480.56 480.56" id="telephone" width="100%" height="100%">
											<path d="M365.354 317.9c-15.7-15.5-35.3-15.5-50.9 0-11.9 11.8-23.8 23.6-35.5 35.6-3.2 3.3-5.9 4-9.8 1.8-7.7-4.2-15.9-7.6-23.3-12.2-34.5-21.7-63.4-49.6-89-81-12.7-15.6-24-32.3-31.9-51.1-1.6-3.8-1.3-6.3 1.8-9.4 11.9-11.5 23.5-23.3 35.2-35.1 16.3-16.4 16.3-35.6-.1-52.1-9.3-9.4-18.6-18.6-27.9-28-9.6-9.6-19.1-19.3-28.8-28.8-15.7-15.3-35.3-15.3-50.9.1-12 11.8-23.5 23.9-35.7 35.5-11.3 10.7-17 23.8-18.2 39.1-1.9 24.9 4.2 48.4 12.8 71.3 17.6 47.4 44.4 89.5 76.9 128.1 43.9 52.2 96.3 93.5 157.6 123.3 27.6 13.4 56.2 23.7 87.3 25.4 21.4 1.2 40-4.2 54.9-20.9 10.2-11.4 21.7-21.8 32.5-32.7 16-16.2 16.1-35.8.2-51.8-19-19.1-38.1-38.1-57.2-57.1zm-19.1-79.7l36.9-6.3c-5.8-33.9-21.8-64.6-46.1-89-25.7-25.7-58.2-41.9-94-46.9l-5.2 37.1c27.7 3.9 52.9 16.4 72.8 36.3 18.8 18.8 31.1 42.6 35.6 68.8zm57.7-160.4c-42.6-42.6-96.5-69.5-156-77.8l-5.2 37.1c51.4 7.2 98 30.5 134.8 67.2 34.9 34.9 57.8 79 66.1 127.5l36.9-6.3c-9.7-56.2-36.2-107.2-76.6-147.7z"></path>
										</svg>
									</svg> Call Us</div>
								<p>+11 22 333 4444</p>
							</div>
							<div class="col-xl-3 col-lg-3 col-md-3">
								<div class="title">
									<svg>
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 13.52 8.2" id="mail" width="100%" height="100%">
											<path d="M12.3 0H1.22A1.22 1.22 0 0 0 0 1.22V7a1.22 1.22 0 0 0 1.22 1.2H12.3A1.22 1.22 0 0 0 13.52 7V1.22A1.22 1.22 0 0 0 12.3 0zm-.17 2l-4.5 2.46a2 2 0 0 1-2 0C1.35 2.08 1.26 2 1.22 2a.44.44 0 0 1-.09-.56.31.31 0 0 1 .46-.12c.15.1 1.79 1 4.38 2.42a1.41 1.41 0 0 0 1.38 0l4.5-2.45a.32.32 0 0 1 .45.19.43.43 0 0 1-.17.52z"></path>
										</svg>
									</svg> Send Us Email</div>
								<p> <a href="mailto:support@{$settings.site_name}.com"><span>{$settings.support_email}</span></a>
								</p>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<!-- end ask modal -->
<!-- footer -->
<footer id="bw-footer">
	<div class="container">
		<div class="row justify-content-between">
			<div class="col-xl-4 col-lg-4 col-md-4 col-sm-push-4">
				<img class="mb-3" src="styles/img/logo/logo.svg" width="200px" style="margin-left: -25px">
				<p class="starter">Simplified Managed Crypto Trading</p>
				<div class="copyright"> <a href="?a=home">{$settings.site_name}</a> GROUP LTD. | &copy;&nbsp; <span>{'Y'|date}</span>
					<br>All Rights Reserved.</div>
			</div>
			<div class="col-xl-5 col-lg-4 col-md-4 d-none d-md-block">
				<ul class="menu">
					<li><a class="active" href="?a=home">Home</a>
					</li>
					<li><a href="?a=cust&amp;page=about">About Us</a>
					</li>
					<li><a href="?a=cust&page=investment">Managed Investment</a>
					</li>
					<li><a href="?a=cust&page=partnership">Referral Program</a>
					</li>
					<li><a href="?a=support">Help Center</a>
					</li>
					<li><a href="?a=news">News</a>
					</li>
				</ul>
			</div>
			<div class="col-xl-3 col-lg-4 col-md-4">
				<div class="details">
					<div class="item d-none d-md-block">
						<svg class="icon">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 511.626 511.626" id="envelope" width="100%" height="100%">
								<path d="M49.106 178.729c6.472 4.567 25.981 18.131 58.528 40.685 32.548 22.554 57.482 39.92 74.803 52.099 1.903 1.335 5.946 4.237 12.131 8.71 6.186 4.476 11.326 8.093 15.416 10.852 4.093 2.758 9.041 5.852 14.849 9.277 5.806 3.422 11.279 5.996 16.418 7.7 5.14 1.718 9.898 2.569 14.275 2.569h.575c4.377 0 9.137-.852 14.277-2.569 5.137-1.704 10.615-4.281 16.416-7.7 5.804-3.429 10.752-6.52 14.845-9.277 4.093-2.759 9.229-6.376 15.417-10.852 6.184-4.477 10.232-7.375 12.135-8.71 17.508-12.179 62.051-43.11 133.615-92.79 13.894-9.703 25.502-21.411 34.827-35.116 9.332-13.699 13.993-28.07 13.993-43.105 0-12.564-4.523-23.319-13.565-32.264-9.041-8.947-19.749-13.418-32.117-13.418H45.679c-14.655 0-25.933 4.948-33.832 14.844C3.949 79.562 0 91.934 0 106.779c0 11.991 5.236 24.985 15.703 38.974 10.466 13.99 21.604 24.983 33.403 32.976z"></path>
								<path d="M483.072 209.275c-62.424 42.251-109.824 75.087-142.177 98.501-10.849 7.991-19.65 14.229-26.409 18.699-6.759 4.473-15.748 9.041-26.98 13.702-11.228 4.668-21.692 6.995-31.401 6.995h-.578c-9.707 0-20.177-2.327-31.405-6.995-11.228-4.661-20.223-9.229-26.98-13.702-6.755-4.47-15.559-10.708-26.407-18.699-25.697-18.842-72.995-51.68-141.896-98.501C17.987 202.047 8.375 193.762 0 184.437v226.685c0 12.57 4.471 23.319 13.418 32.265 8.945 8.949 19.701 13.422 32.264 13.422h420.266c12.56 0 23.315-4.473 32.261-13.422 8.949-8.949 13.418-19.694 13.418-32.265V184.437c-8.186 9.132-17.7 17.417-28.555 24.838z"></path>
							</svg>
						</svg> <a class="rexlink" href="mailto:{$settings.support_email|default:'demo@goldcoders.com'}"><span>{$settings.support_email|default:'demo@goldcoders.com'}</span></a>
					</div>
					<div class="item d-none d-md-block">
						<svg class="icon">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 480.56 480.56" id="telephone" width="100%" height="100%">
								<path d="M365.354 317.9c-15.7-15.5-35.3-15.5-50.9 0-11.9 11.8-23.8 23.6-35.5 35.6-3.2 3.3-5.9 4-9.8 1.8-7.7-4.2-15.9-7.6-23.3-12.2-34.5-21.7-63.4-49.6-89-81-12.7-15.6-24-32.3-31.9-51.1-1.6-3.8-1.3-6.3 1.8-9.4 11.9-11.5 23.5-23.3 35.2-35.1 16.3-16.4 16.3-35.6-.1-52.1-9.3-9.4-18.6-18.6-27.9-28-9.6-9.6-19.1-19.3-28.8-28.8-15.7-15.3-35.3-15.3-50.9.1-12 11.8-23.5 23.9-35.7 35.5-11.3 10.7-17 23.8-18.2 39.1-1.9 24.9 4.2 48.4 12.8 71.3 17.6 47.4 44.4 89.5 76.9 128.1 43.9 52.2 96.3 93.5 157.6 123.3 27.6 13.4 56.2 23.7 87.3 25.4 21.4 1.2 40-4.2 54.9-20.9 10.2-11.4 21.7-21.8 32.5-32.7 16-16.2 16.1-35.8.2-51.8-19-19.1-38.1-38.1-57.2-57.1zm-19.1-79.7l36.9-6.3c-5.8-33.9-21.8-64.6-46.1-89-25.7-25.7-58.2-41.9-94-46.9l-5.2 37.1c27.7 3.9 52.9 16.4 72.8 36.3 18.8 18.8 31.1 42.6 35.6 68.8zm57.7-160.4c-42.6-42.6-96.5-69.5-156-77.8l-5.2 37.1c51.4 7.2 98 30.5 134.8 67.2 34.9 34.9 57.8 79 66.1 127.5l36.9-6.3c-9.7-56.2-36.2-107.2-76.6-147.7z"></path>
							</svg>
						</svg> <span>+11 22 333 4444</span>
					</div>
					<div class="item mt-4">
						<ul class="socials">
							<li>
								<a target="_black" href="https://www.facebook.com">
									<svg>
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 90 90" id="facebook" width="100%" height="100%">
											<path d="M90 15.001C90 7.119 82.884 0 75 0H15C7.116 0 0 7.119 0 15.001v59.998C0 82.881 7.116 90 15.001 90H45V56H34V41h11v-5.844C45 25.077 52.568 16 61.875 16H74v15H61.875C60.548 31 59 32.611 59 35.024V41h15v15H59v34h16c7.884 0 15-7.119 15-15.001V15.001z"></path>
										</svg>
									</svg>
								</a>
							</li>
							<li>
								<a target="_black" href="https://twitter.com">
									<svg>
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 612 612" id="twitter" width="100%" height="100%">
											<path d="M612 116.258a250.714 250.714 0 0 1-72.088 19.772c25.929-15.527 45.777-40.155 55.184-69.411-24.322 14.379-51.169 24.82-79.775 30.48-22.907-24.437-55.49-39.658-91.63-39.658-69.334 0-125.551 56.217-125.551 125.513 0 9.828 1.109 19.427 3.251 28.606-104.326-5.24-196.835-55.223-258.75-131.174-10.823 18.51-16.98 40.078-16.98 63.101 0 43.559 22.181 81.993 55.835 104.479a125.556 125.556 0 0 1-56.867-15.756v1.568c0 60.806 43.291 111.554 100.693 123.104-10.517 2.83-21.607 4.398-33.08 4.398-8.107 0-15.947-.803-23.634-2.333 15.985 49.907 62.336 86.199 117.253 87.194-42.947 33.654-97.099 53.655-155.916 53.655-10.134 0-20.116-.612-29.944-1.721 55.567 35.681 121.536 56.485 192.438 56.485 230.948 0 357.188-191.291 357.188-357.188l-.421-16.253c24.666-17.593 46.005-39.697 62.794-64.861z"></path>
										</svg>
									</svg>
								</a>
							</li>
							<li>
								<a href="javascript:backToTop()"></a>
							</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>
</footer>
<!-- end footer -->
<!-- java scripts -->
<script src="https://code.jquery.com/jquery-1.9.1.min.js" integrity="sha256-wS9gmOZBqsqWxgIVgA8Y9WcQOa7PgSIX+rPA0VL2rbQ=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/1.17.0/TweenMax.min.js"></script>
<script src="styles/js/plugins/CustomEase.min.js"></script>
<script src="styles/js/plugins/SplitText.min.js"></script>
<script src="styles/js/plugins/ScrollMagic.js"></script>
<script src="styles/js/methods.js"></script>
<script src="styles/js/app.js?v=1.0.1"></script>
<script src="styles/js/plugins/jquery.browser.js"></script>
<script src="styles/js/plugins/jquery-iframe-auto-height.min.js"></script>
<script>
	document.write("<script type='text/javascript' src='styles/js/faq.js?v=" + Date.now() + "'><\/script>");
</script>
<script src="styles/js/plugins/jquery.hideseek.min.js"></script>

<!-- end java scripts -->
</body>

</html>
<script>
	$('.cf-mask .close-mask').click(function () {
	       $('#ask-modal').css('display','none');
	    });
	    $('.ask-now').click(function () {
	        $('#ask-modal').css('display','block');
	    });
	    $(document).mouseup(function(e)
	    {
	        var container = $(".cf-mask .cf-mask-wrapper .main");
	        if (!container.is(e.target) && container.has(e.target).length === 0)
	        {
	            $('#ask-modal').css('display','none');
	        }
	    });
</script>